<?php

/**
 *
 * Plugin Name: TweetBinder Partners
 * Plugin URL: https://www.tweetbinder.com
 * Description: TweetBinder Partners - [tb-partners]
 * Version: 2.1
 * Author: TweetBinder Dev Team <dev@tweetbinder.com>
 * Author URI: https://www.tweetbinder.com
 *
 **/


add_action('wp_head', 'tbp_include_library');
function tbp_include_library(){
  $search_box_options = get_option(
    'tb_search_box_options',
    []
  );
  $url = isset($search_box_options['url']) && !empty($search_box_options['url'])
    ? $search_box_options['url']
    : 'https://test.tweetbinder.com:51001/cdn/tb-web-components.js';

  echo '<script src="' . $url . '" id="tweetbinder-search-box-js"></script>';
};

function tbp_shortcode($atts)
{

  // normalize attribute keys, lowercase
  $atts = array_change_key_case( (array) $atts, CASE_LOWER );
  $partner_config = get_option(
    'tb_partner_config',
    []
  );
  $partner_id=$partner_config['affiliate-id'];
  $dictionary=json_encode(get_option('tb-dictionary'));

  if( !empty($atts['product-id']) ) {
    $title=$atts['title'];
    $cta=$atts['cta'];
    $attributes=$atts['attributes'];

    $product_box_attributes='product-id='.$atts['product-id'].' affiliate-id='.$partner_id.' dictionary="'.$dictionary.'"';
    if(!empty($title)){
      $product_box_attributes=' '.$product_box_attributes.'title="'.$title.'"';
    }

    if(!empty($cta)){
      $product_box_attributes=' '.$product_box_attributes.'cta="'.$cta.'"';
    }

    if(!empty($attributes)){
      $product_box_attributes=' '.$product_box_attributes.'attributes="'.$attributes.'"';
    }
    return '<tb-product-box '.$product_box_attributes.'></tb-product-box>';
  }

  $language = 'en';

  $style = [];
  $styles = get_option(
    !empty($atts['ct-box'])
      ? 'tb_tracker_form'
      : 'tb_search_box',
    []
  );

  foreach (array_keys($styles) as $key) {
    if (!empty($styles[$key])) {
      $style[] = "--c-" . $key . ':'. $styles[$key];
    }
  };

  $placeholder=$styles['placeholder'];
  $cta=$styles['cta'];


  $plugin_attributes='lang="' . $language . '" custom-styles="'. implode('; ', $style) .'" dictionary="'.$dictionary.'"';

  if( !empty($atts['md-box']) ) {
    $md_atts = $plugin_attributes;
    if(!empty($atts['cta'])) {
      $md_atts = $md_atts . ' ' . 'cta="' . $atts['cta'] . '"';
    }
    if(!empty($atts['placeholder'])) {
      $md_atts = $md_atts . ' ' . 'placeholder="' . $atts['placeholder'] . '"';
    }
    return '<tb-media-downloader-form '.$md_atts.'></tb-media-downloader-form>';
  }

  if($placeholder){
    $plugin_attributes=$plugin_attributes.' '.'placeholder="'.$placeholder.'"';
  }

  if($cta){
    $plugin_attributes=$plugin_attributes.' '.'cta="'.$cta.'"';
  }

  if ($partner_id) {
    $plugin_attributes=$plugin_attributes.' '.'affiliate-id="'.$partner_id.'"';
  }

  if( !empty($atts['ct-box']) ) {
    return '<tb-create-tracker-form '.$plugin_attributes.'></tb-create-tracker-form>';
  }

  return '<tb-search-box '.$plugin_attributes.'></tb-search-box>';
}

add_shortcode('tb-partners', 'tbp_shortcode');


add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'tbp_add_plugin_page_settings_link');
function tbp_add_plugin_page_settings_link($links)
{
  $links[] = '<a href="' .
    admin_url('options-general.php?page=tb_partners') .
    '">' . __('Settings') . '</a>';
  return $links;
}

// Create settings page
add_action('admin_menu', 'tbp_search_box_settings');
add_action('admin_init', 'tbp_search_box_init');

function tbp_search_box_settings()
{
  add_options_page('Tweet Binder Partners', 'Tweet Binder Partners', 'manage_options', 'tb_partners', 'tb_partners');
}

function tbp_search_box_init()
{
  // Create settings group
  register_setting('tb_partner_config', 'tb_partner_config', ['default' => []]);
  register_setting('tb_search_box', 'tb_search_box', ['default' => []]);
  register_setting('tb_tracker_form', 'tb_tracker_form', ['default' => []]);
  register_setting('tb_product_box', 'tb_product_box', ['default' => []]);

  add_settings_section(
    'tb_partner_config',
    __('Partner ID', 'wordpress'),
    'tbp_partner_config_callback',
    'tb_partner_config'
  );

  add_settings_field(
    'affiliate-id',
    __('Partner Id', 'wordpress'),
    'tbp_partner_id_render',
    'tb_partner_config',
    'tb_partner_config'
  );

  add_settings_section(
    'tb_search_box',
    __('Hashtag Search Box - <strong>[tb-partners]</strong>', 'wordpress'),
    'tbp_search_box_callback',
    'tb_search_box'
  );


  add_settings_field(
    'placeholder',
    __('Placeholder text', 'wordpress'),
    'tbp_placeholder_render',
    'tb_search_box',
    'tb_search_box'
  );

  add_settings_field(
    'cta',
    __('Button text', 'wordpress'),
    'tbp_cta_render',
    'tb_search_box',
    'tb_search_box'
  );

  add_settings_field(
    'text-color',
    __('Input text color', 'wordpress'),
    'tbp_text_color_render',
    'tb_search_box',
    'tb_search_box'
  );

  add_settings_field(
    'icon-color',
    __('Text Button color', 'wordpress'),
    'tbp_icon_color_render',
    'tb_search_box',
    'tb_search_box'
  );

  add_settings_field(
    'button-color',
    __('Background Button color', 'wordpress'),
    'tbp_search_button_render',
    'tb_search_box',
    'tb_search_box'
  );

  add_settings_section(
    'tb_tracker_form',
    __('User Tracker Box - <strong>[tb-partners ct-box=1]</strong>', 'wordpress'),
    'tbp_tracker_form_callback',
    'tb_tracker_form'
  );

  add_settings_section(
    'tb_product_box',
    __('Product Box', 'wordpress'),
    'tbp_product_box_callback',
    'tb_product_box'
  );

  foreach([
    [
      'id' => 'placeholder',
      'label' => 'Placeholder text',
      'placeholder' => 'Type here the @usernames separated by commas: @jack,@tweetbinder,@tweetbinderpro,@caosasuna"'
    ],
    [
      'id' => 'cta',
      'label' => 'Button Text',
      'placeholder' => 'Create tracker'
    ],
    [
      'id' => 'text-color',
      'label' => 'Input text color',
      'placeholder' => '#000'
    ],
    [
      'id' => 'icon-color',
      'label' => 'Text Button color',
      'placeholder' => '#FFF'
    ],
    [
      'id' => 'button-color',
      'label' => 'Background button color',
      'placeholder' => '#1DA1F2'
    ],
  ] as $input) {
    add_settings_field(
      $input['id'],
      __($input['label'], 'wordpress'),
      'tbp_input_render',
      'tb_tracker_form',
      'tb_tracker_form',
      [
        'options' => 'tb_tracker_form',
        'input' => $input['id'],
        'placeholder' => $input['placeholder'],
      ]
    );

  }
}

function tbp_input_render($params) {
  $options = get_option($params['options']);
  ?>
  <input
    type="text"
    name="<?php printf('%s[%s]', $params['options'], $params['input']) ?>"
    value="<?php echo isset($options[$params['input']]) ? $options[$params['input']] : ''; ?>"
    placeholder="<?php echo $params['placeholder'] ?>"
  /><?php
}

function tbp_icon_color_render()
{
  $options = get_option('tb_search_box');
?>
  <input
    type='text'
    name='tb_search_box[icon-color]'
    value='<?php echo isset($options['icon-color']) ? $options['icon-color'] : ''; ?>'
    placeholder="#FFF"
  >
<?php
}

function tbp_text_color_render()
{
  $options = get_option('tb_search_box');
?>
  <input
    type='text'
    name='tb_search_box[text-color]'
    value='<?php echo isset($options['text-color']) ? $options['text-color'] : ''; ?>'
    placeholder="#000"
  >
<?php
}

function tbp_partner_id_render()
{
  $options = get_option('tb_partner_config');
?>
  <input
    type='text'
    name='tb_partner_config[affiliate-id]'
    value='<?php echo isset($options['affiliate-id']) ? $options['affiliate-id'] : ''; ?>'
    placeholder="Paste here your partner id"
  >
<?php
}

function tbp_search_button_render()
{
  $options = get_option('tb_search_box');
?>
  <input
    type='text'
    name='tb_search_box[button-color]'
    value='<?php echo isset($options['button-color']) ? $options['button-color'] : ''; ?>'
    placeholder="#1DA1F2"
  >
<?php
}


function tbp_placeholder_render()
{
  $options = get_option('tb_search_box');
?>
  <input
    type='text'
    name='tb_search_box[placeholder]'
    value='<?php echo isset($options['placeholder']) ? $options['placeholder'] : ''; ?>'
    placeholder="Type here your hashtag or keyword"
  >
<?php
}

function tbp_cta_render()
{
  $options = get_option('tb_search_box');
?>
  <input
    type='text'
    name='tb_search_box[cta]'
    value='<?php echo isset($options['cta']) ? $options['cta'] : ''; ?>'
    placeholder="Create report"
  >
<?php
}


function tbp_search_box_callback()
{
  echo __('<p>Paste this code <strong>[tb-partners] </strong>in any post or page to insert the Tweet Binder hashtag search box. You can use it in as many pages and posts as you want, the more you place it in your posts and pages the more possibilities you will have to make a sale.</p><p>Configure the appearance of the box here:</p>', 'wordpress');
}


function tbp_tracker_form_callback()
{
  echo __('<p>Paste this code <strong>[tb-partners ct-box=1] </strong>in any post or page to insert the Tweet Binder user tracker box. This will create a user tracker so the visitors of your site will be able to see the growth of followers or any account. For more info about this go <a href="https://www.tweetbinder.com/blog/twitter-follower-tracker/" target="_blank">here</a>.&nbsp;</p><p>Configure the appearance of the box here:</p>', 'wordpress');
}

function tbp_product_box_callback()
{
  echo __('<p>Use <strong>[tb-partners product-id="PRODUCT-CODE"]</strong> to insert the <strong>Tweet Binder Products Module</strong> wherever you want. Check <a href="https://www.tweetbinder.com/blog/how-to-make-money-on-twitter/" target="_blank" rel="noopener,noreferrer">here</a> the product codes.</p>  <ul>
    <li>You can customize the TITLE of the Products module by adding shortcode params [tb-partners product-id="report-twitter-7-day" title="My product box"]</li>
    <li>You can customize the CTA of the Products module by adding shortcode params [tb-partners product-id="report-twitter-7-day" cta="Get"]</li>
    <li>You can customize the ATTRIBUTES of the Products module by adding shortcode params [tb-partners product-id="report-twitter-7-day" attributes="Attribute1;Attribute2"]</li>
  </ul>', 'wordpress');
}


function tbp_partner_config_callback()
{
  echo __('<p>Add your Partner Id in the box below. If you don\'t have a partner ID, go to <a href="https://www.tweetbinder.com/partners/" target="_blank" rel="noopener,noreferrer">our Partners Page</a> and register as a partner.</p>
<p>If you are already registered check your email (and your SPAM folder) to get your partner ID or <a href="https://www.tweetbinder.com/contact/" target="_blank" rel="noopener,noreferrer"">contact us</a> now.</p>
', 'wordpress');
}

function tbp_dictionary_callback()
{
  echo __('Define dictionary', 'wordpress');
}

function tb_partners()
{
?>
  <h1>How to use the Tweet Binder Partners Plugin</h1>
  <p>Welcome Partner! We are happy to have you on board, our Partners community welcomes you. With the Tweet Binder Partners Plugin you will be able to generate money when the users you bring purchase a report or a plan.</p>
  <p>You will find in this page all the info you need to set up your plugin and start generating revenue today.</p>
  <p>Remember to add your Partner ID.</p>

  <h2>Tweet Binder Partners plugin</h2>
  <?php foreach([
    'tb_partner_config',
    'tb_search_box',
    'tb_tracker_form',
    // Disabled since MAR-1182
    // https://tweetbinder.atlassian.net/browse/MAR-1182?focusedCommentId=49425
    //'tb_product_box',
  ] as $section): ?>
    <form action='options.php' method='post'>
      <?php
        settings_fields($section);
        do_settings_sections($section);
        submit_button();
      ?>
    </form>
    <?php endforeach;
}
?>
